/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack.preprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.coderbot.iris.Iris;
import net.coderbot.iris.shaderpack.StringPair;
import net.coderbot.iris.shaderpack.option.ShaderPackOptions;
import net.coderbot.iris.shaderpack.preprocessor.PropertiesCommentListener;
import net.coderbot.iris.shaderpack.preprocessor.PropertyCollectingListener;
import org.anarres.cpp.Feature;
import org.anarres.cpp.LexerException;
import org.anarres.cpp.Preprocessor;
import org.anarres.cpp.PreprocessorCommand;
import org.anarres.cpp.PreprocessorListener;
import org.anarres.cpp.Source;
import org.anarres.cpp.StringLexerSource;
import org.anarres.cpp.Token;

public class PropertiesPreprocessor {
    public static String preprocessSource(String string3, ShaderPackOptions shaderPackOptions, Iterable<StringPair> iterable) {
        String string4;
        if (string3.contains("#warning IRIS_PASSTHROUGH ") || string3.contains("IRIS_PASSTHROUGHBACKSLASH")) {
            throw new RuntimeException("Some shader author is trying to exploit internal Iris implementation details, stop!");
        }
        List<String> list = PropertiesPreprocessor.getBooleanValues(shaderPackOptions);
        Map<String, String> map = PropertiesPreprocessor.getStringValues(shaderPackOptions);
        Preprocessor preprocessor = new Preprocessor();
        try {
            for (String object : list) {
                preprocessor.addMacro(object);
            }
            for (StringPair stringPair : iterable) {
                preprocessor.addMacro(stringPair.getKey(), stringPair.getValue());
            }
            map.forEach((string, string2) -> {
                try {
                    preprocessor.addMacro(string, string2);
                }
                catch (LexerException lexerException) {
                    lexerException.printStackTrace();
                }
            });
            string4 = PropertiesPreprocessor.process(preprocessor, string3);
        }
        catch (Throwable throwable) {
            try {
                try {
                    preprocessor.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                throw new RuntimeException("Unexpected IOException while processing macros", iOException);
            }
            catch (LexerException lexerException) {
                throw new RuntimeException("Unexpected LexerException processing macros", lexerException);
            }
        }
        preprocessor.close();
        return string4;
    }

    public static String preprocessSource(String string, Iterable<StringPair> iterable) {
        if (string.contains("#warning IRIS_PASSTHROUGH ")) {
            throw new RuntimeException("Some shader author is trying to exploit internal Iris implementation details, stop!");
        }
        Preprocessor preprocessor = new Preprocessor();
        try {
            for (StringPair stringPair : iterable) {
                preprocessor.addMacro(stringPair.getKey(), stringPair.getValue());
            }
        }
        catch (LexerException lexerException) {
            lexerException.printStackTrace();
        }
        return PropertiesPreprocessor.process(preprocessor, string);
    }

    private static String process(Preprocessor preprocessor, String object) {
        preprocessor.setListener((PreprocessorListener)new PropertiesCommentListener());
        PropertyCollectingListener propertyCollectingListener = new PropertyCollectingListener();
        preprocessor.setListener((PreprocessorListener)propertyCollectingListener);
        object = Arrays.stream(((String)object).split("\\R")).map(String::trim).map(string -> {
            if (string.startsWith("#")) {
                for (PreprocessorCommand preprocessorCommand : PreprocessorCommand.values()) {
                    if (!string.startsWith("#" + preprocessorCommand.name().replace("PP_", "").toLowerCase(Locale.ROOT))) continue;
                    return string;
                }
                return "";
            }
            return string.replace("#", "");
        }).collect(Collectors.joining("\n")) + "\n";
        object = ((String)object).replace("\\", "IRIS_PASSTHROUGHBACKSLASH");
        preprocessor.addInput((Source)new StringLexerSource((String)object, true));
        preprocessor.addFeature(Feature.KEEPCOMMENTS);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Token token;
            while ((token = preprocessor.token()) != null && token.getType() != 265) {
                stringBuilder.append(token.getText());
            }
        }
        catch (Exception exception) {
            Iris.logger.error("Properties pre-processing failed", exception);
        }
        object = stringBuilder.toString();
        return (propertyCollectingListener.collectLines() + (String)object).replace("IRIS_PASSTHROUGHBACKSLASH", "\\");
    }

    private static List<String> getBooleanValues(ShaderPackOptions shaderPackOptions) {
        ArrayList<String> arrayList = new ArrayList<String>();
        shaderPackOptions.getOptionSet().getBooleanOptions().forEach((string, mergedBooleanOption) -> {
            boolean bl = shaderPackOptions.getOptionValues().getBooleanValueOrDefault((String)string);
            if (bl) {
                arrayList.add((String)string);
            }
        });
        return arrayList;
    }

    private static Map<String, String> getStringValues(ShaderPackOptions shaderPackOptions) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        shaderPackOptions.getOptionSet().getStringOptions().forEach((string, mergedStringOption) -> hashMap.put((String)string, shaderPackOptions.getOptionValues().getStringValueOrDefault((String)string)));
        return hashMap;
    }
}

